#!/usr/bin/env bash

# SPDX-FileCopyrightText: 2022 Patrick Spek <p.spek@tyil.nl>
#
# SPDX-License-Identifier: AGPL-3.0-or-later

subcommand()
{
	local buffer

	export BASHTARD_PLAYBOOK="$1" ; shift

	if [[ -z "$BASHTARD_PLAYBOOK" ]]
	then
		crit "bashtard/del" "No playbook name specified"
		return
	fi

	local playbook_base="$BASHTARD_ETCDIR/playbooks.d/$BASHTARD_PLAYBOOK"
	local playbook_registry="$BASHTARD_ETCDIR/registry.d/${BASHTARD_PLATFORM[fqdn]}"

	# Make sure we only run add if the playbook is not in the registry yet
	if ! grep -Fqx "$BASHTARD_PLAYBOOK" "$playbook_registry"
	then
		crit "bashtard/add" "'$BASHTARD_PLAYBOOK' is not registered for ${BASHTARD_PLATFORM[fqdn]}"
		return 3
	fi

	notice "bashtard/del" "Removing playbook '$BASHTARD_PLAYBOOK' from '${BASHTARD_PLATFORM[fqdn]}'"

	if [[ ! -d "$playbook_base" ]]
	then
		emerg "bashtard/sync" "No such directory: $playbook_base"
		return 1
	fi

	if [[ ! -f "$playbook_base/playbook.bash" ]]
	then
		emerg "bashtard/sync" "No such file: $playbook_base/playbook.bash"
		return 1
	fi

	# shellcheck disable=SC1090
	. "$playbook_base/playbook.bash"

	if ! playbook_del
	then
		crit "bashtard/del" "$BASHTARD_PLAYBOOK reported an error"
		return 1
	fi

	buffer="$(tmpfile)"

	# Remove the playbook from the registry
	cp -- "$playbook_registry" "$buffer"
	grep -Fqvx "$BASHTARD_PLAYBOOK" "$buffer" \
		| sort > "$playbook_registry"
}
