#!/usr/bin/env bash

# SPDX-FileCopyrightText: 2022 Patrick Spek <p.spek@tyil.nl>
#
# SPDX-License-Identifier: AGPL-3.0-or-later

subcommand()
{
	remote="$1" ; shift

	if [[ -z "$remote" ]]
	then
		info "init" "No remote given, initializing from scratch"
		init_local
		return
	fi

	init_remote "$remote"
}

init_local()
{
	local dirs=(
		"$BASHTARD_ETCDIR"
		"$BASHTARD_ETCDIR/conf.d"
		"$BASHTARD_ETCDIR/hosts.d"
		"$BASHTARD_ETCDIR/os.d"
		"$BASHTARD_ETCDIR/playbooks.d"
		"$BASHTARD_ETCDIR/registry.d"
		"$BASHTARD_ETCDIR/registry.d/${BASHTARD_PLATFORM[fqdn]}"
	)

	local files=(
		"$BASHTARD_ETCDIR/defaults"
		"$BASHTARD_ETCDIR/secrets"
		"$BASHTARD_ETCDIR/hosts.d/${BASHTARD_PLATFORM[fqdn]}"
		"$BASHTARD_ETCDIR/os.d/${BASHTARD_PLATFORM[key]}"
		"$BASHTARD_ETCDIR/playbooks.d/remotes"
	)

	for dir in "${dirs[@]}"
	do
		notice "bashtard/init" "Creating $dir"
		mkdir -p -- "$dir"
	done

	for file in "${files[@]}"
	do
		notice "bashtard/init" "Creating $file"
		touch -- "$file"
	done

	chmod 600 -- "$BASHTARD_ETCDIR/secrets"

	cat > "$BASHTARD_ETCDIR/.gitignore" <<-EOF
	secrets
	EOF
}

init_remote()
{
	local remote="$1" ; shift

	notice "init" "Cloning $remote to $BASHTARD_ETCDIR"
	git clone "$remote" "$BASHTARD_ETCDIR"

	local files=(
		"$BASHTARD_ETCDIR/hosts.d/${BASHTARD_PLATFORM[fqdn]}"
		"$BASHTARD_ETCDIR/os.d/${BASHTARD_PLATFORM[key]}"
		"$BASHTARD_ETCDIR/registry.d/${BASHTARD_PLATFORM[fqdn]}"
	)

	for file in "${files[@]}"
	do
		[[ -f "$file" ]] && continue

		notice "bashtard/init" "Creating $file"
		touch -- "$file"
	done

	while read -r playbook url _
	do
		notice "bashtard/init" "Cloning $playbook from $url"
		git clone "$url" "$BASHTARD_ETCDIR/playbooks.d/$playbook"

		# TODO: Clone appropriate branch
	done < "$BASHTARD_ETCDIR/playbooks.d/remotes"
}
