#!/usr/bin/env bash

# SPDX-FileCopyrightText: 2022 Patrick Spek <p.spek@tyil.nl>
#
# SPDX-License-Identifier: AGPL-3.0-or-later

subcommand()
{
	local ssh

	ssh="$(config "app.ssh")"

	if [[ ! -d "$BASHTARD_ETCDIR/hosts.d" ]]
	then
		crit "$BASHTARD_NAME/ssh" "Could not find hosts file at $BASHTARD_ETCDIR/hosts.d"
		return 3
	fi

	chgdir "$BASHTARD_ETCDIR/hosts.d"

	for node in *
	do
		local user
		local host

		user="$(config_for "$node" "ssh.user" "root")"

		# Try IPv6 first
		host="$(config_for "$node" "ssh.host" "$(config_for "$node" "vpn.ipv6")")"

		if [[ -z "$host" ]]
		then
			# Otherwise try IPv4
			host="$(config_for "$node" "ssh.host" "$(config_for "$node" "vpn.ipv4")")"
		fi

		notice "ssh" "$user@$node ($host) > $*"

		$ssh "$user@$host" "$@"

		unset user
		unset host
	done
}
