#!/usr/bin/env bash

# OS independent package management
pkg() {
	local system="bashtard/pkg"
	local action=$1 ; shift
	local pkg

	pkg="$(config "pkg.$1")" ; shift

	if [[ -z $pkg ]]
	then
		crit "$system" "No package name for $pkg"
		return 1
	fi

	if [[ "$(type -t "pkg_$action")" != "function" ]]
	then
		crit "$system" "Invalid package manager action $action"
		return 1
	fi

	"pkg_$action" "$pkg"
}

pkg_install() {
	local system="bashtard/pkg/install"

	local app=$1 ; shift

	case "${BASHTARD_PLATFORM[key]}" in
		freebsd)       set -- /usr/sbin/pkg install -y "$app" ;;
		linux-debian*) set -- apt install -y "$app" ;;
		linux-gentoo)  set -- emerge --ask=n --update "$app" ;;
		*)
			crit "$system" "No package manager configured for ${BASHTARD_PLATFORM[key]}"
			return 1
			;;
	esac

	notice "$system" "$*"
	# shellcheck disable=SC2068
	$@
}

pkg_uninstall() {
	local system="bashtard/pkg/uninstall"

	local app=$1 ; shift

	case "${BASHTARD_PLATFORM[key]}" in
		freebsd)       set -- /usr/sbin/pkg uninstall -y "$app" ;;
		linux-debian*) set -- apt remove -y "$app" ;;
		linux-gentoo)  set -- emerge --ask=n --unmerge "$app" ;;
		*)
			crit "$system" "No package manager configured for ${BASHTARD_PLATFORM[key]}"
			return 1
			;;
	esac

	notice "$system" "$*"
	# shellcheck disable=SC2068
	$@
}
