bashtard(7) "/etc/bashtard"

# HIERARCHY

# defaults

The defaults file is a _bashtard(5)_ key-value file. It specifies the values of
variables in case there are no host or os specific values.

# hosts.d

The *hosts.d* directory contains one file for each specific host you're managing
with *bashtard*, in the _bashtard(5)_ key-value format. The variables defined in
this file take precedence over those defined in *os.d*.

# os.d

The *os.d* directory contains any number of files, named after the _key_ value
reported by *bashtard sysinfo*. This allows you to set variables on a
os-by-os basis, for instance for package names which differ between between
certain GNU+Linux distributions.

# playbooks.d

The *playbooks.d* directory contains a single plain-text file, *remotes*,
describing all the remote playbooks tracked by *bashtard*. The layout of
playbooks themselves can be found in _playbooks.d(7)_.

## remotes

The *remotes* file is a space-seperated file, specifying a _name_, _url_, and
_branch_ per line, to use for keeping remote playbooks synchronized.

```
webserver  https://git.tyil.nl/bashtard-webserver.git  master
```

# registry.d

The *registry.d* contains one file for each specific host you're managing with
*bashtard*. It keeps track of which playbooks are added to each host, to use
when the *sync* subcommand is invoked. Entries get added to this registry
automatically when using the *add* subcommand, and removed when using the *del*
subcommand.

# SEE ALSO

- _bashtard(5)_ -- Configuration files and formats used by Bashtard
