#!/usr/bin/env bash

# SPDX-FileCopyrightText: 2022 Patrick Spek <p.spek@tyil.nl>
#
# SPDX-License-Identifier: AGPL-3.0-or-later

# The base function to output logging information. This should *not* be used
# directly, but the helper functions can be used safely.
log() {
	local system=$1 ; shift

	printf "\e[32m[%s]\e[m \e[33m%s[\e[m%s\e[0;33m]\e[m: %s\e[m\n" \
		"$(date +%FT%T)" \
		"$system" \
		"$$" \
		"$*" \
		>&2
}

debug()  { [[ -n $BASHTARD_DEBUG ]] && log "$1" "$(printf "\e[0;37m%s" "${@:2}")" ; }
info()   { log "$1" "$(printf "\e[m%s"     "${@:2}")" ; }
notice() { log "$1" "$(printf "\e[0;34m%s" "${@:2}")" ; }
warn()   { log "$1" "$(printf "\e[1;39m%s" "${@:2}")" ; }
crit()   { log "$1" "$(printf "\e[0;33m%s" "${@:2}")" ; }
alert()  { log "$1" "$(printf "\e[0;31m%s" "${@:2}")" ; }
emerg()  { log "$1" "$(printf "\e[1;31m%s" "${@:2}")" ; }
