#!/usr/bin/env bash

# SPDX-FileCopyrightText: 2022 Patrick Spek <p.spek@tyil.nl>
#
# SPDX-License-Identifier: AGPL-3.0-or-later

subcommand()
{
	local key
	local value
	local secret

	# Handle opts
	while getopts ":p:s" opt
	do
		case "$opt" in
			p) export BASHTARD_PLAYBOOK="$OPTARG" ;;
			s) secret=1 ;;
			*) emerg "Unused opt '$opt'?" ;;
		esac
	done

	shift $(( OPTIND - 1 ))

	key="$1" ; shift
	value="$1" ; shift

	if [[ -z "$key" ]]
	then
		emerg "bashtard/var" "You must supply a key"
		return 3
	fi

	if [[ -z "$value" ]]
	then
		# Just show the value of the given key
		printf "%s=%s\n" "$key" "$(config "$key")"
		return
	fi

	# Set the var for this specific host
	local kvfile
	local buffer

	if [[ $secret ]]
	then
		kvfile="$BASHTARD_ETCDIR/secrets"
	else
		kvfile="$BASHTARD_ETCDIR/hosts.d/${BASHTARD_PLATFORM[fqdn]}"
	fi

	buffer="$(tmpfile)"

	grep -v "^$key=" < "$kvfile" > "$buffer"
	printf "%s=%s\n" "$key" "$value" >> "$buffer"
	sort "$buffer" > "$kvfile"
}
