#!/usr/bin/env bash

# SPDX-FileCopyrightText: 2023 Patrick Spek <p.spek@tyil.nl>
#
# SPDX-License-Identifier: AGPL-3.0-or-later

subcommand()
{
	local buffer
	local playbook_base
	local playbook_registry

	export BASHTARD_PLAYBOOK="$1" ; shift

	if [[ -z "$BASHTARD_PLAYBOOK" ]]
	then
		crit "bashtard/del" "No playbook name specified"
		return
	fi

	playbook_base="$(playbook_path "base")"
	playbook_registry="$BASHTARD_ETCDIR/registry.d/${BASHTARD_PLATFORM[fqdn]}"

	# Make sure we only run add if the playbook is not in the registry yet
	if ! grep -Fqx "$BASHTARD_PLAYBOOK" "$playbook_registry"
	then
		crit "bashtard/del" "'$BASHTARD_PLAYBOOK' is not registered for ${BASHTARD_PLATFORM[fqdn]}"
		return 3
	fi

	notice "bashtard/del" "Removing playbook '$BASHTARD_PLAYBOOK' from '${BASHTARD_PLATFORM[fqdn]}'"

	if [[ ! -d "$playbook_base" ]]
	then
		emerg "bashtard/del" "No such directory: $playbook_base"
		return 1
	fi

	if [[ ! -f "$playbook_base/playbook.bash" ]]
	then
		emerg "bashtard/del" "No such file: $playbook_base/playbook.bash"
		return 1
	fi

	# shellcheck disable=SC1090,SC1091
	. "$playbook_base/playbook.bash"

	if ! playbook_del
	then
		crit "bashtard/del" "$BASHTARD_PLAYBOOK reported an error"
		return 1
	fi

	buffer="$(tmpfile)"

	# Remove the playbook from the registry
	cp -- "$playbook_registry" "$buffer"
	grep -Fvx "$BASHTARD_PLAYBOOK" "$buffer" \
		| sort > "$playbook_registry"
}
