#!/usr/bin/env bash

# SPDX-FileCopyrightText: 2023 Patrick Spek <p.spek@tyil.nl>
#
# SPDX-License-Identifier: AGPL-3.0-or-later

subcommand()
{
	local buffer
	local playbook_registry

	export BASHTARD_PLAYBOOK="$1" ; shift

	if [[ -z "$BASHTARD_PLAYBOOK" ]]
	then
		crit "bashtard/zap" "No playbook name specified"
		return
	fi

	playbook_registry="$BASHTARD_ETCDIR/registry.d/${BASHTARD_PLATFORM[fqdn]}"

	# Make sure we only run add if the playbook is not in the registry yet
	if ! grep -Fqx "$BASHTARD_PLAYBOOK" "$playbook_registry"
	then
		crit "bashtard/zap" "'$BASHTARD_PLAYBOOK' is not registered for ${BASHTARD_PLATFORM[fqdn]}"
		return 3
	fi

	notice "bashtard/zap" "Removing playbook '$BASHTARD_PLAYBOOK' from '${BASHTARD_PLATFORM[fqdn]}'"

	buffer="$(tmpfile)"

	# Remove the playbook from the registry
	cp -- "$playbook_registry" "$buffer"
	grep -Fvx "$BASHTARD_PLAYBOOK" "$buffer" \
		| sort > "$playbook_registry"
}
