#!/usr/bin/env bash

# SPDX-FileCopyrightText: 2023 Patrick Spek <p.spek@tyil.nl>
#
# SPDX-License-Identifier: AGPL-3.0-or-later

subcommand()
{
	local dirty

	notice "bashtard/pull" "Pulling latest changes in $BASHTARD_ETCDIR"

	if ! git -C "$BASHTARD_ETCDIR" diff-index --quiet HEAD --
	then
		dirty=1
	fi

	[[ -n $dirty ]] && git -C "$BASHTARD_ETCDIR" stash
	git -C "$BASHTARD_ETCDIR" pull origin master || return 4
	git -C "$BASHTARD_ETCDIR" submodule update --init --recursive || return 4
	[[ -n $dirty ]] && git -C "$BASHTARD_ETCDIR" stash pop

	return 0
}
