#!/usr/bin/env bash

# SPDX-FileCopyrightText: 2022 Patrick Spek <p.spek@tyil.nl>
#
# SPDX-License-Identifier: AGPL-3.0-or-later

subcommand()
{
	local buffer

	export BASHTARD_PLAYBOOK="$1" ; shift

	if [[ -z "$BASHTARD_PLAYBOOK" ]]
	then
		crit "bashtard/add" "No playbook name specified"
		return 2
	fi

	local playbook_base="$BASHTARD_ETCDIR/playbooks.d/$BASHTARD_PLAYBOOK"
	local playbook_registry="$BASHTARD_ETCDIR/registry.d/${BASHTARD_PLATFORM[fqdn]}"

	# Make sure we only run add if the playbook is not in the registry yet
	if grep -Fqx "$BASHTARD_PLAYBOOK" "$playbook_registry"
	then
		crit "bashtard/add" "'$BASHTARD_PLAYBOOK' is already registered for ${BASHTARD_PLATFORM[fqdn]}"
		return 3
	fi

	notice "bashtard/add" "Adding playbook '$BASHTARD_PLAYBOOK' to '${BASHTARD_PLATFORM[fqdn]}'"

	if [[ ! -d "$playbook_base" ]]
	then
		emerg "bashtard/add" "No such directory: $playbook_base"
		return 1
	fi

	if [[ ! -f "$playbook_base/playbook.bash" ]]
	then
		emerg "bashtard/add" "No such file: $playbook_base/playbook.bash"
		return 1
	fi

	# shellcheck disable=SC1090
	. "$playbook_base/playbook.bash"

	if ! playbook_add
	then
		crit "bashtard/add" "$BASHTARD_PLAYBOOK reported an error"
		return 1
	fi

	buffer="$(tmpfile)"

	# Add the playbook to the registry
	cp -- "$playbook_registry" "$buffer"
	printf -- "%s\n" "$BASHTARD_PLAYBOOK" >> "$buffer"
	sort -- "$buffer" > "$playbook_registry"
}
