#!/usr/bin/env bash

# SPDX-FileCopyrightText: 2022 Patrick Spek <p.spek@tyil.nl>
#
# SPDX-License-Identifier: AGPL-3.0-or-later

subcommand()
{
	export BASHTARD_PLAYBOOK="$1" ; shift

	# If a specific playbook is given, sync that
	if [[ -n "$BASHTARD_PLAYBOOK" ]]
	then
		sync_playbook "$BASHTARD_PLAYBOOK"
		return
	fi

	notice "bashtard/sync" "Syncing $BASHTARD_ETCDIR"
	pushd -- "$BASHTARD_ETCDIR" > /dev/null
	git pull origin master || return 4
	popd > /dev/null

	# Otherwise, do a full sync
	notice "bashtard/sync" "Syncing remote playbooks"

	# Update all playbook sources
	while read -r playbook _ branch
	do
		pushd -- "$BASHTARD_ETCDIR/playbooks.d/$playbook" > /dev/null \
			|| return 2
		git pull origin "$branch"
		popd > /dev/null
	done < "$BASHTARD_ETCDIR/playbooks.d/remotes"

	# Run a sync for each registered playbook for this host
	while read -r playbook
	do
		info "bashtard/sync" "Syncing $playbook"
		"$BASHTARD_BIN" sync "$playbook"
	done < "$BASHTARD_ETCDIR/registry.d/${BASHTARD_PLATFORM[fqdn]}"
}

sync_playbook()
{
	local playbook_base="$BASHTARD_ETCDIR/playbooks.d/$BASHTARD_PLAYBOOK"

	notice "bashtard/sync" "Running sync for $BASHTARD_PLAYBOOK"

	if [[ ! -d "$playbook_base" ]]
	then
		emerg "bashtard/sync" "No such directory: $playbook_base"
		return 1
	fi

	if [[ ! -f "$playbook_base/playbook.bash" ]]
	then
		emerg "bashtard/sync" "No such file: $playbook_base/playbook.bash"
		return 1
	fi

	# shellcheck disable=SC1090
	. "$playbook_base/playbook.bash"

	playbook_sync
}
