#!/usr/bin/env bash

# Read a particular value from a key/value configuration file. Using this
# function introduces a dependency on awk.
config() {
	config_for "${BASHTARD_PLATFORM[fqdn]}" "$@"
}

config_for() {
	local host=$1 ; shift
	local key=$1 ; shift
	local default=$1 ; shift

	local default
	local file
	local files

	files=(
		"$BASHTARD_ETCDIR/secrets"
		"$BASHTARD_ETCDIR/hosts.d/$host"
		"$BASHTARD_ETCDIR/os.d/${BASHTARD_PLATFORM[key]}"
		"$BASHTARD_ETCDIR/defaults"
	)

	if [[ -n "$BASHTARD_PLAYBOOK" ]]
	then
		debug "bashtard/config_for" "BASHTARD_PLAYBOOK=$BASHTARD_PLAYBOOK, adding etc entries"
		files+=(
			"$BASHTARD_ETCDIR/playbooks.d/$BASHTARD_PLAYBOOK/etc/os.d/${BASHTARD_PLATFORM[key]}"
			"$BASHTARD_ETCDIR/playbooks.d/$BASHTARD_PLAYBOOK/etc/defaults"
		)
	fi

	files+=(
		"$BASHTARD_SHAREDIR/os.d/${BASHTARD_PLATFORM[key]}"
		"$BASHTARD_SHAREDIR/defaults"
	)

	# Check configuration files
	for file in "${files[@]}"
	do
		debug "bashtard/config_for" "Checking for '$key' in '$file'"

		[[ ! -f $file ]] && continue

		value="$(awk -F= '$1 == "'"$key"'" { print $NF }' "$file")"

		if [[ -n $value ]]
		then
			debug "bashtard/config_for" "Found $key=$value in $file"

			printf "%s" "$value"
			return
		fi
	done

	# Return default value
	if [[ -n $default ]]
	then
		printf "%s" "$default"
		return
	fi

	# Error
	alert "bashtard/config_for" "No configuration value for $key"
}
