bashtard(1)

# NAME

bashtard - A Bash-based configuration management utility

# SYNOPSIS

*bashtard* -h++
*bashtard* add <_playbook_>++
*bashtard* del <_playbook_>++
*bashtard* init [_repository_]++
*bashtard* ssh <_command_>++
*bashtard* sync [_playbook_]++
*bashtard* var [-p _playbook_] <_key_>++
*bashtard* var [-s] <_key_> <_value_>++
*bashtard* sysinfo

# DESCRIPTION

*bashtard* is a relatively simple Bash-based utility, providing just enough
abstractions over certain OS-specific tools to allow you to write generic
configuration and maintenance scripts, known as *playbooks*.

## add

Adds a playbook to the current host. This will trigger the *playbook_add()*
function of the *playbook.bash* file in the root of the playbook directory. It
will also record the playbook name in the host's registry, so it will be taken
into account during a *sync*.

## del

Removes a playbook from the current host. This will trigger the *playbook_del()*
function of the *playbook.bash* file in the root of the playbook directory. It
also removes the playbook name from the host's registry, no longer including it
during a *sync*.

## init

Initializes *bashtard*, creating the required directory structure in
*/etc/bashtard*, or your OS's equivalent directory. You can check the *sysinfo*
subcommand to determine the *etcdir* if in doubt.

If a repository URL has been provided, *bashtard* will attempt to use *git
clone* to create the directory structure, and then add host-specific files to it
afterwards.

## ssh

Run a given command over SSH to all configured nodes. Every node needs to have
*ssh.host* configured for this to work.

## sync

Synchronizes the etcdir and all registered playbooks. The etcdir is synchronized
using *git pull*, after which it will check the host's registry to run the
*playbook_sync()* function of all playbooks enabled on the machine.

## var

Allows debugging of variables used by *bashtard*. When given a key, it will
return the *key=value* format to give you insight of what a variable will be on
the current host. It accepts a *-p <playbook>* option, to get the value of a
given variable when used in a given _playbook_.

Alternatively, you can also supply a second positional argument, which will
become the value of the given variable. This will be saved in the host-specific
configuration file. This variant accepts the *-s* option, to instead save it to
the *secrets* file, which should only be readable by the user maintaining the
system through *bashtard*.

# SEE ALSO

- _bashtard(3)_ -- Functions and variables exposed by *bashtard* for use in
                 playbooks
- _bashtard(5)_ -- Configuration files and formats used by *bashtard*
- _bashtard(7)_ -- Filesystem layout for /etc/bashtard
- _playbooks.d(7)_ -- Filesystem layout for /etc/bashtard/playbooks.d
