bashtard(3)

# INTRODUCTION

When writing a *playbook*, you will want to know of the variables and functions
exposed by *bashtard*, so that you can actually write OS-agnostic installation
and maintenance scripts.

# VARIABLES

These are the variables which are supported by *bashtard* for use in
*playbooks*. There are more *$BASHTARD_* variables, but these are intended for
internal use only, and should thus *NOT* be relied on in *playbooks*.

## BASHTARD_BIN

The absolute path to the *bashtard* binary.

## BASHTARD_PLATFORM

The *$BASHTARD_PLATFORM* variable contains all sorts of information about the
platform it is currently running on. It is an array with the following keys:

- arch -- The name of the architecture
- distro -- The name of the GNU+Linux distribution, if any
- fqdn -- The fully-qualified domain name of the machine
- key -- A "key" to uniquely identify the OS
- os -- The name of the OS
- term -- The name of the current-running terminal
- version -- The release version of the OS, if any

These can be used to handle edge-cases when trying to configure things, though
with abstractions like _pkg_ and _svc_, you shouldn't need these directly. The
*key* of the *$BASHTARD_PLATFORM* array is used to find the right configuration
file in *os.d* for configuration value resolution. Refer to _bashtard(5)_ for
more information on this.

## BASHTARD_PLAYBOOK

The name of the currently running playbook.

# FUNCTIONS

## config $key

The *config()* function lets you retrieve a particular config value based on the
given _key_. Refer to _bashtard(5)_ for more information about configuration
value resolution.

## file_template $template [$var ...]

The *file_template()* function lets you perform simple templating on a file.
There is no logic, only very simple substitution through the power of *sed*. You
can specify any number of _var_ arguments as key=value pairs, which will be
substituted in the template file. In the template, you can specify these as
_${key}_. The templates will be looked for in the *share* directory inside the
playbook directory.

## pkg $action $pkg

The *pkg()* function abstracts away the running system's package manager,
allowing you to write more OS-agnostic playbooks. The _action_ can be either
*install* or *uninstall*. The actual package name which will be installed will
be looked up through *config()*, in the form of _pkg.$pkg_.

For instance, if you call *pkg install nginx*, the *pkg()* function will try to
resolve the *pkg.nginx*, and install whichever value it came up with. These are
generally defined in the *os.d* of a *playbook*, to handle situations where
certain systems name their packages differently.

## svc $action $svc

The *svc()* function abstracts away the running system's service manager,
allowing you to write more OS-agnostic playbooks. The _action_ can be one of the
following:

- *disable*
- *enable*
- *start*
- *stop*
- *reload*
- *restart*

The actual service name which will be acted upon will be looked up through
*config()*, in the form of _svc.$svc_, much like with the *pkg()* function.

## tmpfile

The *tmpfile()* function lets you create temporary files as needed. It does not
take an argument, and returns you a path for a temporary file to which you can
write. Cleanup will be done automatically after *bashtard* exits.
