#!/usr/bin/env bash

# SPDX-FileCopyrightText: 2023 Patrick Spek <p.spek@tyil.nl>
#
# SPDX-License-Identifier: AGPL-3.0-or-later

subcommand()
{
	export BASHTARD_PLAYBOOK="$1" ; shift

	# If a specific playbook is given, sync that
	if [[ -n "$BASHTARD_PLAYBOOK" ]]
	then
		sync_playbook "$BASHTARD_PLAYBOOK"
		return
	fi

	# Pull latest changes
	"$BASHTARD_BIN" pull

	# Run a sync for each registered playbook for this host
	while read -r playbook
	do
		info "bashtard/sync" "Syncing $playbook"
		"$BASHTARD_BIN" sync "$playbook"
	done < "$BASHTARD_ETCDIR/registry.d/${BASHTARD_PLATFORM[fqdn]}"
}

sync_playbook()
{
	local playbook_base
	local missing_vars=0

	playbook_base="$(playbook_path "base")"

	notice "bashtard/sync" "Running sync for $BASHTARD_PLAYBOOK"

	if [[ ! -d "$playbook_base" ]]
	then
		emerg "bashtard/sync" "No such directory: $playbook_base"
		return 1
	fi

	if [[ ! -f "$playbook_base/playbook.bash" ]]
	then
		emerg "bashtard/sync" "No such file: $playbook_base/playbook.bash"
		return 1
	fi

	# shellcheck disable=SC1090,SC1091
	. "$playbook_base/playbook.bash"

	debug "bashtard/sync" "Checking for \$BASHTARD_PLAYBOOK_VARS"

	# Ensure all required vars are non-empty
	for key in "${!BASHTARD_PLAYBOOK_VARS[@]}"
	do
		# shellcheck disable=SC2086
		in_args "required" ${BASHTARD_PLAYBOOK_VARS[$key]} || continue

		debug "bashtard/sync" "Checking \$BASHTARD_PLAYBOOK_VARS[$key]"

		if [[ "$(config "$key")" == "" ]]
		then
			missing_vars=$(( missing_vars + 1))
		fi
	done

	if (( 0 < missing_vars ))
	then
		emerg "bashtard/sync" "One or more required variables are unset"
		return 3
	fi

	# Run the playbook
	playbook_sync
}
