<!--
SPDX-FileCopyrightText: 2023 Patrick Spek <p.spek@tyil.nl>

SPDX-License-Identifier: AGPL-3.0-or-later
-->

# Bashtard

Bashtard is a small configuration management system written in Bash.

## Getting Started

Since Bashtard is written in bash, you will need to have Bash available in your
`$PATH`. You will also need to have a POSIX compatible system, and the
associated utilities installed and available in your `$PATH`. Lastly, to keep
your setup synchronized, `git` is used.

Once you have everything installed, Bashtard itself can be installed using the
provided `Makefile`.

    make install

### Initialization

When Bashtard is installed, the next step is initializing the system. The `init`
subcommand will perform all necesary steps to create the desired structure in
`/etc/bashtard`.

    bashtard init

It is recommended you create a `git` directory out of `/etc/bashtard` for
synchronization purposes. This will allow you to initialize Bashtard on other
systems by giving it the URL of the git repository as additional argument.

    bashtard init https://git.tyil.nl/tyilnet.git

With the additional argument, it will clone the repository to `/etc/bashtard`,
and then apply any additional steps for the machine you're initializing.

## General Usage

After initializing, you can start using Bashtard. It has the concept of
playbooks, which can either be local or cloned from a remote git repository.

### One-off updates

To perform updates once by hand, use the `sync` subcommand.

    bashtard sync

This will pull the latest changes of remote playbooks, and then run a `sync`
command for each playbook that is used on the machine.

### Regular updates

If you want to do updates on a regular basis, you should configure your
preferred cron system to do so.

### Playbooks

These are the essential components for doing the actual work. Playbooks are
directories with a `description.txt` and a `playbook.bash`. The latter contains
3 functions, `playbook_add()`, `playbook_sync()`, and `playbook_del()`, each
called for the `add`, `sync`, end `del` subactions respectively. Using these
functions, one can automate the setup, synchronization, or disabling of certain
components of a system.

### SSH

Bashtard comes with an `ssh` subcommand to allow the user to run any command on
all their servers. This can be useful for performing certain actions on all your
servers at once.

## Debugging and Support

For support you can email to `~tyil/bashtard@lists.sr.ht`. If you're reporting a
bug, it is recommended to include a reproduction path which is as clear as
possible. Additionally, you should include the output of the `sysinfo`
subcommand.

## License

This project is licensed under the terms of the AGPL-3.0.
