#!/usr/bin/env bash

# SPDX-FileCopyrightText: 2023 Patrick Spek <p.spek@tyil.nl>
#
# SPDX-License-Identifier: AGPL-3.0-or-later

subcommand()
{
	if [[ ! -d "$BASHTARD_ETCDIR/hosts.d" ]]
	then
		crit "$BASHTARD_NAME/ssh" "Could not find hosts file at $BASHTARD_ETCDIR/hosts.d"
		return 3
	fi

	chgdir "$BASHTARD_ETCDIR/hosts.d"

	for node in *
	do
		local user
		local host

		user="$(config_for "$node" "bashtard.ssh.user" "$USER")"
		host="$(config_for "$node" "bashtard.ssh.host")"

		if [[ -z "$host" ]]
		then
			crit "$BASHTARD_NAME/ssh" "bashtard.ssh.host is not configured for $node"
			continue
		fi

		notice "$BASHTARD_NAME/ssh" "$user@$node ($host) > $*"

		# shellcheck disable=SC2029
		ssh "$user@$host" "$@"

		unset user
		unset host
	done
}
