<!--
SPDX-FileCopyrightText: 2024 Patrick Spek <p.spek@tyil.nl>

SPDX-License-Identifier: AGPL-3.0-or-later
-->

# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [UNRELEASED]

### Fixed

- `config_subkeys` and `config_subkeys_for` should now leave off the `&` at the
  end of a variable names which are references.

## [2.1.0] - 2024-04-02

### Added

- Configuration variables can be assigned values of other variables with the
  `&=` assignment. This allows a single value to be re-used dynamically, rather
  than having to explicitly set the same value several times.
- A `zap` command has been added to remove a playbook from the registry without
  running the playbook's `playbook_del()` function. This is intended to easily
  remove registry entries when a playbook itself has been deleted or is
  otherwise broken in a way that the regular `del` subcommand cannot fix.

### Changed

- The `description.txt` is now allowed to be used without the `.txt` suffix.
  Usage with the `.txt` suffix continues to be supported as well.

### Fixed

- Passing an empty string as default value to `config` should now properly
  return an empty string without a warning about the configuration key not
  existing.

## [2.0.2] - 2024-02-28

### Fixed

- Configuration values with `=` in their value part should now work properly
  with `file_template`. Keys with `=` in them are still *not supported*.

## [2.0.1] - 2023-09-25

### Added

- A new `make` target has been added to build a .tar.gz distributable.

### Changed

- The `svc_` utils should now check which init service you're using when using a
  linux system. The supported options are still only openrc and systemd.
- The `pull` subcommand should now properly return with exit-code 0 if no
  problem were encountered.

## [2.0.0] - 2023-05-22

### Added

- The `var` subcommand is now referenced in `usage()`.
- A `pkg` subcommand has been added, to allow for direct interaction with the
  `pkg_*()` utilities provided by Bashtard.
- `config_subkeys()` and `config_subkeys_for` have been added, to look up
  subkeys defined in config files. These can help when you want to use a list
  somewhere in your configuration.
- A `backup` subcommand has been added. This backup system uses borg, which must
  be installed, but should be generic enough to be usable by most people out of
  the box.
- The `Makefile` has been extended with targets for creating packages for
  GNU+Linux distributions.
- The `$BASHTARD_PLATFORM` variable now contains an additional entry, `init`, to
  allow for handling different init systems on GNU+Linux in a cleaner fashion.
- A `file_hash` utility function has been added. It currently uses `md5`, but is
  written in such a fashion that this can easily be updated for the future. Its
  intent is to encapsulate differences between naming and usage of hashing
  utilities found on different systems.
- A `dir_hash` utility function has been added, which will give you a hash based
  on the file contents of a directory. This function will find files
  recursively, calculate a hash for each of them, and then calculate a hash
  based on the total result. The intended goal is to allow running before and
  after templating some files, to deduce whether something actually changed.
- A `diff` subcommand has been added to show all non-committed changes. It is a
  convenience wrapper to avoid having to change directory and run `git diff` to
  get an overview of all pending changes.
- A `pull` subcommand has been added to only pull the latest changes into the
  `$BASHTARD_ETCDIR`, without running `sync` on all the playbooks.
- A new global variable, `$BASHTARD_PLAYBOOK_VARS` has been added. Currently,
  its only purpose is to check for "required" variables to be used in the
  playbook. Before an `add` or `sync`, any variables declared to be `required`
  in the `$BASHTARD_PLAYBOOK_VARS` array will be checked to be non-empty. If any
  are empty, an error will be thrown and the playbook will not be ran.
- A new directory has been added, `data.d`, for data that should be shared
  between playbook runs. This new directory is intended to create a clearer
  seperation between a playbook and a user's specific data used by the playbook,
  which in turn should make re-using playbooks easier.
- A convenience function has been introduced, `playbook_path()`, which can give
  you the absolute path to the playbook's base or data directory.
- A `top` subcommand has been added to give some generic information of all
  nodes known to Bashtard. It uses information from the `sysinfo` subcommand,
  which it will pull in through an `ssh` invocation.

### Changed

- The `ssh` subcommand's configuration has been nested under `bashtard`, e.g.
  `ssh.host` is now `bashtard.ssh.host`. It should also be correctly using this
  value for establishing the SSH connection.
- `svc_enable()` now checks for the `rc.d` file to exist before running `grep`
  on it.
- `pkg_*()` functions no longer _require_ a `pkg.*` value to be defined. If one
  is not set explicitly, a warning will be generated, but the original name
  passed to the `pkg_*()` function will be used by the host's package manager.
- `datetime()` now always passes `-u` on to `date`.
- All manpages now include a `NAME` section.
- The `sync` subcomman will now `stash` any changes before it attempts to
  `pull`. Afterwards, `stash pop` will be ran to apply the last `stash`ed
  changes again.

## [1.0.0] - 2022-05-06

Initial release.
