bashtard(7) "/etc/bashtard"

; SPDX-FileCopyrightText: 2023 Patrick Spek <p.spek@tyil.nl>
; SPDX-License-Identifier: AGPL-3.0-or-later

# NAME

bashtard - A Bash-based configuration management utility

# HIERARCHY

# defaults

The defaults file is a _bashtard(5)_ key-value file. It specifies the values of
variables in case there are no host or os specific values.

# data.d

The *data.d* directory contains a directory for each playbook that actively uses
it. It stores data generated or otherwise used by the playbook between
consecutive runs. This allows a playbook writer to keep a clear seperation
between a user's data and the playbook.

# hosts.d

The *hosts.d* directory contains one file for each specific host you're managing
with *bashtard*, in the _bashtard(5)_ key-value format. The variables defined in
this file take precedence over those defined in *os.d*.

# os.d

The *os.d* directory contains any number of files, named after the _key_ value
reported by *bashtard sysinfo*. This allows you to set variables on a
os-by-os basis, for instance for package names which differ between between
certain GNU+Linux distributions.

# playbooks.d

The *playbooks.d* directory contains all the playbook directories. For more
information, check _playbooks.d(7)_.

# registry.d

The *registry.d* contains one file for each specific host you're managing with
*bashtard*. It keeps track of which playbooks are added to each host, to use
when the *sync* subcommand is invoked. Entries get added to this registry
automatically when using the *add* subcommand, and removed when using the *del*
subcommand.

# SEE ALSO

- _bashtard(5)_ -- Configuration files and formats used by Bashtard
