// Copyright (C) 2025  Patrick "tyil" Spek <p.spek@tyil.nl>
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as
// published by the Free Software Foundation, either version 3 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <https://www.gnu.org/licenses/>.

package config

var config Config
var defaults = Config{
	Announcement: "",
	Auth: ConfigAuth{
		UserHeader:   "X-Authentik-Username",
		GroupsHeader: "X-Authentik-Groups",
		Separator:    "|",
	},
	Defaults: ConfigDefaults{
		IconSet:  "simple-icons",
		IconName: "simpleicons",
	},
	ReloadMiddleware: false,
	Server: ConfigServer{
		Address: "0.0.0.0",
		Port:    8080,
	},
	Style: ConfigStyle{
		Colors: ConfigStyleColors{
			BackgroundPrimary:      "#333333",
			BackgroundSecondary:    "#555555",
			BackgroundAnnouncement: "#ffff90",
			TextPrimary:            "#f7f7f7",
			TextSecondary:          "#aaaaaa",
			TextLink:               "#0097fc",
			TextAnnouncement:       "#000000",
		},
		Fonts: ConfigStyleFonts{
			Footer:  "sans-serif",
			Header:  "sans-serif",
			Primary: "sans-serif",
			Tags:    "sans-serif",
		},
		Transformations: ConfigStyleTransformations{
			LinkBrightnessHover:  0.7,
			LinkBrightnessActive: 0.3,
			IconFilter:           "grayscale(1) brightness(0)",
			IconSize:             "48px",
		},
	},
	Title: "DashLab",
}
