// Copyright (C) 2025  Patrick "tyil" Spek <p.spek@tyil.nl>
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as
// published by the Free Software Foundation, either version 3 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <https://www.gnu.org/licenses/>.

package config

type Config struct {
	Announcement     string
	Auth             ConfigAuth
	Defaults         ConfigDefaults
	ReloadMiddleware bool `yaml:"reload-middleware"`
	Sections         []ConfigSection
	Server           ConfigServer
	Style            ConfigStyle
	Title            string
}

type ConfigApp struct {
	Title       string
	Description string
	Icon        ConfigAppIcon
	Url         string
	Groups      []string
	Tags        []string
}

type ConfigAppIcon struct {
	Url  string
	Set  string
	Name string
}

type ConfigAuth struct {
	UserHeader   string `yaml:"user-header"`
	GroupsHeader string `yaml:"groups-header"`
	Separator    string
}

type ConfigDefaults struct {
	IconSet  string `yaml:"icon-set"`
	IconName string `yaml:"icon-name"`
}

type ConfigSection struct {
	Title       string
	Description string
	Apps        []ConfigApp
}

type ConfigServer struct {
	Address string
	Port    uint
}

type ConfigStyle struct {
	Fonts           ConfigStyleFonts
	Colors          ConfigStyleColors
	Transformations ConfigStyleTransformations
}

type ConfigStyleColors struct {
	TextPrimary      string `yaml:"text-primary"`
	TextSecondary    string `yaml:"text-secondary"`
	TextLink         string `yaml:"text-link"`
	TextAnnouncement string `yaml:"text-announcement"`

	BackgroundPrimary      string `yaml:"background-primary"`
	BackgroundSecondary    string `yaml:"background-secondary"`
	BackgroundAnnouncement string `yaml:"background-announcement"`

	Tags map[string]ConfigStyleColorsTags
}

type ConfigStyleColorsTags struct {
	Background string
	Text       string
}

type ConfigStyleFonts struct {
	Primary string
	Tags    string
	Header  string
	Footer  string
}

type ConfigStyleTransformations struct {
	LinkBrightnessHover  float64 `yaml:"link-brightness-hover"`
	LinkBrightnessActive float64 `yaml:"link-brightness-active"`
	IconFilter           string  `yaml:"icon-filter"`
	IconSize             string  `yaml:"icon-size"`
}
