// Copyright (C) 2025  Patrick "tyil" Spek <p.spek@tyil.nl>
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as
// published by the Free Software Foundation, either version 3 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <https://www.gnu.org/licenses/>.

package handlers

import (
	"html/template"
	"log/slog"
	"net/http"

	"dashlab/config"
	"dashlab/license"
)

func WhoAmI(res http.ResponseWriter, req *http.Request) {
	// Get templates
	tpl, err := template.ParseFiles(
		"templates/base.gotpl",
		"templates/who_am_i.gotpl",
	)
	if err != nil {
		slog.Error(err.Error())

		res.WriteHeader(http.StatusInternalServerError)
		res.Write([]byte(err.Error()))

		return
	}

	// Return rendered template
	err = tpl.Execute(res, map[string]interface{}{
		"Announcement": config.Get().Announcement,
		"Auth":         config.Get().Auth,
		"HttpReq":      req,
		"License":      template.HTML(license.AGPL_3_header_html),
		"Title":        config.Get().Title,
	})
	if err != nil {
		slog.Error(err.Error())

		res.Write([]byte(err.Error()))
	}
}
