// Copyright (C) 2025  Patrick "tyil" Spek <p.spek@tyil.nl>
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as
// published by the Free Software Foundation, either version 3 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <https://www.gnu.org/licenses/>.

package middlewares

import (
	"dashlab/config"
	"log/slog"
	"net/http"
)

func Logging(next http.Handler) http.Handler {
	return http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		x_forwarded_for := r.Header.Get("X-Forwarded-For")
		x_real_ip := r.Header.Get("X-Real-IP")
		x_user := r.Header.Get(config.Get().Auth.UserHeader)

		slog.Info(
			"Handling request",
			"remote", r.RemoteAddr,
			"forwarded_for", x_forwarded_for,
			"real_ip", x_real_ip,
			"path", r.URL.Path,
			"user", x_user,
		)

		next.ServeHTTP(w, r)
	})
}
